import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: drawTrans
    name: "trans"
    effectName: "DrawTrans"
    property string syncBaseName: "zoomer"

    property string transShader: "zoomTrans"
    property alias transParams: tsp.delegate

    property string drawShader: "zoomDraw"
    property alias drawParams: drawItRep.delegate

    property string drawBlendMode: "normal"

    property real zoomPercent: 0.01
    property real emitIntervalMS: 40

    property real drawTexUvScale: 0.02

    property bool transPack: false

    property string file

    // shaderVaryings define the transform feedback emit and input vertex data structure
    property string shaderVaryings: "
        vec3 posG;
        vec3 normalG;
        vec2 uvG;
        vec3 tangentG;
        float brightG;
        vec3 origCenterG;"

    property int gWidth: 4000
    Shader {
        file: sceneDir+transShader; tfVaryings: shaderVaryings;
        ShaderParam { paramName: "g_emit"; paramValue: 0.0}
        ShaderParam { paramName: "g_zoomAmount"; paramValue: 1.0+zoomPercent}
    }

    // start drawing (with transform feedback) triangles to sceneName+"trans" named vertex buffer object (vbo)
    // all Draw* after this and before "drawStop" has the render to the screen disabled (goes only to the vertex buffer)
    DrawVB {
        type: "drawStart"; primType: "triangles"; vboId: sceneName+drawTrans.name; tfVaryings: shaderVaryings;
        enabled: true
        halfFloats: transPack
        intPack: transPack
        reset: sync(drawTrans.syncBaseName+".reset")
        onResetChanged: {if (reset > 0.5) resetParticles();}
        gridWidth: gWidth; gridHeight: 1000
        drawNumPoints: gridWidth*gridHeight
        depthTest: false; depthWrite: false
        Repeater { id: tsp; model: 1 }
    }

    property real prevTi: 0.0
    property real ki: 0.0
    property real kii: 0.0
    property real pr: sync(drawTrans.syncBaseName+".emitTrack.innerRad")
    property real er: sync(drawTrans.syncBaseName+".emitTrack.rad")
    property bool resetTrack: sync(drawTrans.syncBaseName+".emitTrack.reset")
    onResetTrackChanged: {
        if (resetTrack) {
            ki = 0.0;
            kii = 0.0;
            prevTi = 0.0;
        }
    }

    property int drawIndex: 0
    Connections {
        target: demo; onFrameRendered: {
            var ti = demoTime();
            var deltaTime = (ti-prevTi);
            if (deltaTime > emitIntervalMS*0.001 || deltaTime < -emitIntervalMS*0.001) {
                ki += (emitIntervalMS*0.001)*sync(drawTrans.syncBaseName+".emitTrack.freq");
                kii += (emitIntervalMS*0.001)*sync(drawTrans.syncBaseName+".emitTrack.freq")*sync(drawTrans.syncBaseName+".emitTrack.innerFreq");
                prevTi = ti;
                if (dm.itemAt(0)) {
                    dm.itemAt(0).triggerRenderOnce();
                }
                drawIndex++;
           }
        }
    }

    // draw the given meshes (as given by the DrawTrans parameters!)
    property alias drawMesh: dm.delegate
    Repeater { id: dm; model: 1 }

    // stop drawing to the vertex buffer (with transform feedback)
    DrawVB {
        enabled: true
        halfFloats: transPack
        intPack: transPack
        type: "drawStop";  primType: "triangles"; vboId: sceneName+drawTrans.name; tfVaryings: shaderVaryings
        gridWidth: gWidth; gridHeight: 1000; drawNumPoints: gridWidth*gridHeight
    }

//    property alias draw: ds.delegate
//    Repeater {
//        id: ds
//        model: 1
//    }

    Shader { file: sceneDir+drawShader }


    DrawVB {
        id: drawIt
        enabled: true
        halfFloats: transPack
        intPack: transPack
        type: "pointGridDraw"
        primType: "triangles"
        vboId: sceneName+drawTrans.name
        tfVaryings: drawTrans.shaderVaryings
        gridWidth: gWidth; gridHeight: 1000
        drawNumPoints: gridWidth*gridHeight
        depthTest: true; depthWrite: true

      // cullBack: true
      //  cull: true

        Repeater { id: drawItRep; model: 1 }

        blendMode: drawBlendMode

        property int pc: particleCount

        onPcChanged: {
            root.setCustomText(drawTrans.name, "triangle count", "triangle count:"+particleCount);
        }
    }

}
